<?php
/**
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2021 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_'))
    exit;



class WdPopupNewsletter extends Module
{
    
    private $_html = '';
    
    private $_postErrors = array();
    
    const GUEST_NOT_REGISTERED = -1;
    
    const CUSTOMER_NOT_REGISTERED = 0;
    
    const GUEST_REGISTERED = 1;
    
    const CUSTOMER_REGISTERED = 2;
    
    
    public function __construct()
    {
        
        $this->name = 'wdpopupnewsletter';
        
        $this->tab = 'front_office_features';
        
        $this->version = '1.0.0';
        
        $this->author = 'WebDigify';
        
        $this->controllers = array(
            'verification'
        );
        
        $this->bootstrap = true;
        
        parent::__construct();
        
        $this->displayName = $this->l('WD Popup Newsletter');
        
        $this->description = $this->l('Shows popup newsletter window with your message');
        
        $this->ps_versions_compliancy = array(
            'min' => '1.6',
            'max' => _PS_VERSION_
        );
        
    }
    
    
    
    public function install()
    {
        
        $this->context->controller->getLanguages();
        
        $title = array();
        
        $content = array();
        
        foreach ($this->context->controller->_languages as $language) {
            
            $title[(int) $language['id_lang']] = 'Newsletter';
            
            $content[(int) $language['id_lang']] = 'Subscribe to the Complex mailing list to receive updates on new arrivals, special offers and other discount information.';
            
        }
        
        //$this->_createTab();
        
        if (parent::install() == false || $this->registerHook('header') == false || $this->registerHook('displaypopupnewsletter') == false || $this->registerHook('displaysocialnews') == false || Configuration::updateValue('WD_TEXT', $content) == false || Configuration::updateValue('WD_TITLE', $title) == false || Configuration::updateValue('WD_WIDTH', 580) == false || Configuration::updateValue('WD_HEIGHT', 610) == false || Configuration::updateValue('WD_NEWSLETTER', true) == false || Configuration::updateValue('WD_BG', true) == false || Configuration::updateValue('WD_BG_IMAGE', _MODULE_DIR_ . $this->name . '/views/img/newsletter.jpg') == false)
            return false;
        return true;
    }
    
    
    
    public function uninstall()
    {
        
        $this->context->controller->getLanguages();
        
        foreach ($this->context->controller->_languages as $language) {
            
            Configuration::deleteByName('WD_TEXT_' . (int) $language['id_lang']);
            
            Configuration::deleteByName('WD_TITLE_' . (int) $language['id_lang']);
            
        }
        
        //$this->_deleteTab();
        
        return Configuration::deleteByName('WD_WIDTH') && Configuration::deleteByName('WD_HEIGHT') && Configuration::deleteByName('WD_NEWSLETTER') && Configuration::deleteByName('WD_BG') && Configuration::deleteByName('WD_BG_IMAGE') && parent::uninstall();
        
    }
    
    public function getContent()
    {
        
        
        $output = '';
        $this->context->controller->getLanguages();
        if (Tools::isSubmit('tt_submit')) {
            
            Configuration::updateValue('WD_WIDTH', (int) Tools::getValue('WD_WIDTH'));
            
            Configuration::updateValue('WD_HEIGHT', (int) Tools::getValue('WD_HEIGHT'));
            
            Configuration::updateValue('WD_NEWSLETTER', (bool) Tools::getValue('WD_NEWSLETTER'));
            
            Configuration::updateValue('WD_BG', Tools::getValue('WD_BG'));
            
            if (Tools::isSubmit('WD_BG_IMAGE')) {
                
                Configuration::updateValue('WD_BG_IMAGE', Tools::getValue('WD_BG_IMAGE'));
                
            }
            
            $message_trads = array();
            
            $message_trads2 = array();
            
            foreach ($_POST as $key => $value) {
                
                if (preg_match('/WD_TITLE_/i', $key)) {
                    
                    $id_lang = preg_split('/WD_TITLE_/i', $key);
                    
                    $message_trads2[(int) $id_lang[1]] = $value;
                    
                }
                
                if (preg_match('/WD_TEXT_/i', $key)) {
                    
                    $id_lang = preg_split('/WD_TEXT_/i', $key);
                    
                    $message_trads[(int) $id_lang[1]] = $value;
                    
                }
                
            }
            
            Configuration::updateValue('WD_TEXT', $message_trads, true);
            
            Configuration::updateValue('WD_TITLE', $message_trads2, true);
            
            
            $this->_clearCache($this->name . '.tpl');
            
            
            
        }
        
        return $output . $this->renderForm();
        
    }
    
    
    
    public function hookdisplaypopupnewsletter()
    {
        
        if (isset($this->context->controller->php_self) && $this->context->controller->php_self == 'index') {
            
            if (!$this->isCached($this->name . '.tpl', $this->getCacheId($this->name))) {
                
                $this->context->smarty->assign(array(
                    
                    'wd_popupnewlestter' => $this->getConfigFromDB()
                    
                ));
                
            }
            
            return $this->display(__FILE__, $this->name . '.tpl');
            
        }
        
    }
    
    
    
    public function hookHeader()
    {
        
        if (isset($this->context->controller->php_self) && $this->context->controller->php_self == 'index') {
            
            $this->context->controller->addJS(($this->_path) . 'views/js/init.js');
            
            $this->context->controller->addCSS(($this->_path) . 'views/css/styles.css', 'all');
            
        }
        
    }
    
    
    
    public function setMedia()
    {
        
        parent::setMedia();
        
        $this->addJqueryUI('ui.datepicker');
        
    }
    
    
    
    public function renderForm()
    {
        
        
        
        $fields_form = array(
            
            'form' => array(
                
                'legend' => array(
                    
                    'title' => $this->l('Module Appearance'),
                    
                    'icon' => 'icon-cogs'
                    
                ),
                
                'input' => array(
                    
                    array(
                        
                        'type' => 'text',
                        
                        'name' => 'WD_TITLE',
                        
                        'label' => $this->l('Popup title'),
                        'required' => false,
                        'class' => 'fixed-width-xxl',
                        'lang' => true,
                        
                        'autoload_rte' => true
                        
                    ),
                    
                    array(
                        
                        'type' => 'text',
                        
                        'label' => $this->l('Width of popup window'),
                        
                        'name' => 'WD_WIDTH',
                        
                        'class' => 'fixed-width-xxl'
                        
                    ),
                    
                    array(
                        
                        'type' => 'text',
                        
                        'label' => $this->l('Height of popup window'),
                        
                        'name' => 'WD_HEIGHT',
                        
                        'class' => 'fixed-width-xxl'
                        
                    ),
                    
                    array(
                        
                        'type' => 'textarea',
                        
                        'label' => $this->l('Popup content'),
                        
                        'name' => 'WD_TEXT',
                        
                        'rows' => 10,
                        
                        'cols' => 40,
                        
                        'lang' => true,
                        
                        'autoload_rte' => true
                        
                    ),
                    
                    array(
                        
                        'type' => 'switch',
                        
                        'label' => $this->l('Show Newsletter form in popup'),
                        
                        'name' => 'WD_NEWSLETTER',
                        
                        'is_bool' => true,
                        
                        'values' => array(
                            
                            array(
                                
                                'id' => 'active_on',
                                
                                'value' => 1,
                                
                                'label' => $this->l('Yes')
                                
                            ),
                            
                            array(
                                
                                'id' => 'active_off',
                                
                                'value' => 0,
                                
                                'label' => $this->l('No')
                                
                            )
                            
                        )
                        
                    ),
                    
                    array(
                        
                        'type' => 'switch',
                        
                        'label' => $this->l('Show background image'),
                        
                        'name' => 'WD_BG',
                        
                        'is_bool' => true,
                        
                        'values' => array(
                            
                            array(
                                
                                'id' => 'active_on',
                                
                                'value' => true,
                                
                                'label' => $this->l('Yes')
                                
                            ),
                            
                            array(
                                
                                'id' => 'active_off',
                                
                                'value' => false,
                                
                                'label' => $this->l('No')
                                
                            )
                            
                        )
                        
                    ),
                    
                    array(
                        
                        'type' => 'background_image',
                        
                        'label' => $this->l('Popup background image'),
                        
                        'name' => 'WD_BG_IMAGE',
                        
                        'size' => 30
                        
                    )
                    
                ),
                
                'submit' => array(
                    
                    'title' => $this->l('Save')
                    
                )
                
            )
            
        );
        
        
        
        
        
        $languages = Language::getLanguages(false);
        
        foreach ($languages as $k => $language)
            $languages[$k]['is_default'] = (int) $language['id_lang'] == Configuration::get('PS_LANG_DEFAULT');
        
        
        
        $helper = new HelperForm();
        
        $helper->show_toolbar = false;
        
        $helper->module = $this;
        
        $helper->name_controller = $this->name;
        
        $helper->identifier = $this->identifier;
        
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        
        $helper->languages = $languages;
        
        $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;
        
        $helper->default_form_language = (int) Configuration::get('PS_LANG_DEFAULT');
        
        $helper->allow_employee_form_lang = true;
        
        $helper->toolbar_scroll = true;
        
        $helper->toolbar_btn = $this->initToolbar();
        
        $helper->title = $this->displayName;
        
        $helper->submit_action = 'tt_submit';
        
        $helper->tpl_vars = array(
            
            'fields_value' => $this->getConfigFieldsValues()
            
        );
        
        return $helper->generateForm(array(
            $fields_form
        ));
        
    }
    
    
    
    private function initToolbar()
    {
        
        $this->toolbar_btn['save'] = array(
            
            'href' => '#',
            
            'desc' => $this->l('Save')
            
        );
        
        return $this->toolbar_btn;
        
    }
    
    public function getConfigFieldsValues()
    {
        
        $values = array(
            
            'WD_WIDTH' => Tools::getValue('WD_WIDTH', Configuration::get('WD_WIDTH')),
            
            'WD_HEIGHT' => Tools::getValue('WD_HEIGHT', Configuration::get('WD_HEIGHT')),
            
            'WD_NEWSLETTER' => Tools::getValue('WD_NEWSLETTER', Configuration::get('WD_NEWSLETTER')),
            
            'WD_BG' => Tools::getValue('WD_BG', Configuration::get('WD_BG')),
            
            'WD_BG_IMAGE' => Tools::getValue('WD_BG_IMAGE', Configuration::get('WD_BG_IMAGE')),
            
            'WD_COUNTDOWN_POPUP' => Tools::getValue('WD_COUNTDOWN_POPUP', Configuration::get('WD_COUNTDOWN_POPUP')),
            
            'WD_COUNTDOWN_POPUP_START' => Tools::getValue('WD_COUNTDOWN_POPUP_START', Configuration::get('WD_COUNTDOWN_POPUP_START'))
            
        );
        
        
        
        foreach (Language::getLanguages(false) as $lang) {
            
            $values['WD_TITLE'][(int) $lang['id_lang']] = Configuration::get('WD_TITLE', (int) $lang['id_lang']);
            
            $values['WD_TEXT'][(int) $lang['id_lang']] = Configuration::get('WD_TEXT', (int) $lang['id_lang']);
            
        }
        
        return $values;
        
    }
    
    
    
    public function getConfigFromDB()
    {
        
        $now = date('Y-m-d H:i:00');
        
        $start_date = (Configuration::get('WD_COUNTDOWN_POPUP_START') ? Configuration::get('WD_COUNTDOWN_POPUP_START') : '0000-00-00 00:00:00');
        
        if (strtotime($start_date) > strtotime($now)) {
            
            $end_date = "0000-00-00 00:00:00";
            
        } else {
            
            $end_date = (Configuration::get('WD_COUNTDOWN_POPUP') ? Configuration::get('WD_COUNTDOWN_POPUP') : '0000-00-00 00:00:00');
            
        }
        
        return array(
            
            'WD_WIDTH' => (Configuration::get('WD_WIDTH') ? Configuration::get('WD_WIDTH') : "400"),
            
            'WD_HEIGHT' => (Configuration::get('WD_HEIGHT') ? Configuration::get('WD_HEIGHT') : "400"),
            
            'WD_NEWSLETTER' => (Configuration::get('WD_NEWSLETTER') ? Configuration::get('WD_NEWSLETTER') : false),
            
            'WD_TEXT' => (Configuration::get('WD_TEXT', $this->context->language->id) ? Configuration::get('WD_TEXT', $this->context->language->id) : false),
            
            'WD_TITLE' => (Configuration::get('WD_TITLE', $this->context->language->id) ? Configuration::get('WD_TITLE', $this->context->language->id) : false),
            
            'WD_BG' => (Configuration::get('WD_BG') ? Configuration::get('WD_BG') : 0),
            
            'WD_BG_IMAGE' => (Configuration::get('WD_BG_IMAGE') ? Configuration::get('WD_BG_IMAGE') : 0),
            
            'WD_PATH' => Tools::getShopProtocol() . Context::getContext()->shop->domain . Context::getContext()->shop->physical_uri . 'modules/wdpopupnewsletter/ajax.php',
            
            'WD_COUNTDOWN_POPUP' => $end_date
            
        );
        
    }
    
    
    
    /**
    
    * Check if this mail is registered for newsletters
    
    *
    
    * @param string $customer_email
    
    *
    
    * @return int -1 = not a customer and not registered
    
    *                0 = customer not registered
    
    *                1 = registered in block
    
    *                2 = registered in customer
    
    */
    
    private function isNewsletterRegistered($customer_email)
    {
        
        $sql = 'SELECT `email`

                FROM ' . _DB_PREFIX_ . 'emailsubscription

                WHERE `email` = \'' . pSQL($customer_email) . '\'

                AND id_shop = ' . $this->context->shop->id;
        
        
        
        if (Db::getInstance()->getRow($sql))
            return self::GUEST_REGISTERED;
        
        
        
        $sql = 'SELECT `newsletter`

                FROM ' . _DB_PREFIX_ . 'customer

                WHERE `email` = \'' . pSQL($customer_email) . '\'

                AND id_shop = ' . $this->context->shop->id;
        
        
        
        if (!$registered = Db::getInstance()->getRow($sql))
            return self::GUEST_NOT_REGISTERED;
        
        
        
        if ($registered['newsletter'] == '1')
            return self::CUSTOMER_REGISTERED;
        
        
        
        return self::CUSTOMER_NOT_REGISTERED;
        
    }
    
    
    
    /**
    
    * Return true if the registered status correspond to a registered user
    
    *
    
    * @param int $register_status
    
    *
    
    * @return bool
    
    */
    
    protected function isRegistered($register_status)
    {
        
        return in_array($register_status, array(
            self::GUEST_REGISTERED,
            self::CUSTOMER_REGISTERED
        ));
        
    }
    
    public function activateGuest($email)
    {
        
        return Db::getInstance()->execute('UPDATE `' . _DB_PREFIX_ . 'emailsubscription`

                        SET `active` = 1

                        WHERE `email` = \'' . pSQL($email) . '\'');
        
    }
    
    
    
    /**
    
    * Returns a guest email by token
    
    *
    
    * @param string $token
    
    *
    
    * @return string email
    
    */
    
    protected function getGuestEmailByToken($token)
    {
        
        $sql = 'SELECT `email`

                FROM `' . _DB_PREFIX_ . 'emailsubscription`

                WHERE MD5(CONCAT( `email` , `newsletter_date_add`, \'' . pSQL(Configuration::get('NW_SALT')) . '\')) = \'' . pSQL($token) . '\'

                AND `active` = 0';
        
        
        
        return Db::getInstance()->getValue($sql);
        
    }
    
    
    /**
    
    * Returns a customer email by token
    
    *
    
    * @param string $token
    
    *
    
    * @return string email
    
    */
    
    protected function getUserEmailByToken($token)
    {
        
        $sql = 'SELECT `email`

                FROM `' . _DB_PREFIX_ . 'customer`

                WHERE MD5(CONCAT( `email` , `date_add`, \'' . pSQL(Configuration::get('NW_SALT')) . '\')) = \'' . pSQL($token) . '\'

                AND `newsletter` = 0';
        
        
        
        return Db::getInstance()->getValue($sql);
        
    }
    
    
    /**
    
    * Subscribe a guest to the newsletter
    
    *
    
    * @param string $email
    
    * @param bool   $active
    
    *
    
    * @return bool
    
    */
    
    protected function registerGuest($email, $active = true)
    {
        
        $sql = 'INSERT INTO ' . _DB_PREFIX_ . 'emailsubscription (id_shop, id_shop_group, email, newsletter_date_add, ip_registration_newsletter, http_referer, active)

                VALUES

                (' . $this->context->shop->id . ',

                ' . $this->context->shop->id_shop_group . ',

                \'' . pSQL($email) . '\',

                NOW(),

                \'' . pSQL(Tools::getRemoteAddr()) . '\',

                (

                    SELECT c.http_referer

                    FROM ' . _DB_PREFIX_ . 'connections c

                    WHERE c.id_guest = ' . (int) $this->context->customer->id . '

                    ORDER BY c.date_add DESC LIMIT 1

                ),

                ' . (int) $active . '

                )';
        
        
        
        return Db::getInstance()->execute($sql);
        
    }
    
    /**
    
    * Return a token associated to an user
    
    *
    
    * @param string $email
    
    * @param string $register_status
    
    */
    
    protected function getToken($email, $register_status)
    {
        
        if (in_array($register_status, array(
            self::GUEST_NOT_REGISTERED,
            self::GUEST_REGISTERED
        ))) {
            
            $sql = 'SELECT MD5(CONCAT( `email` , `newsletter_date_add`, \'' . pSQL(Configuration::get('NW_SALT')) . '\')) as token

                    FROM `' . _DB_PREFIX_ . 'emailsubscription`

                    WHERE `active` = 0

                    AND `email` = \'' . pSQL($email) . '\'';
            
        }
        
        else if ($register_status == self::CUSTOMER_NOT_REGISTERED) {
            
            $sql = 'SELECT MD5(CONCAT( `email` , `date_add`, \'' . pSQL(Configuration::get('NW_SALT')) . '\' )) as token

                    FROM `' . _DB_PREFIX_ . 'customer`

                    WHERE `newsletter` = 0

                    AND `email` = \'' . pSQL($email) . '\'';
            
        }
        
        
        
        return Db::getInstance()->getValue($sql);
        
    }
    
    
    
    /**
    
    * Ends the registration process to the newsletter
    
    *
    
    * @param string $token
    
    *
    
    * @return string
    
    */
    
    public function confirmEmail($token)
    {
        
        $activated = false;
        
        
        
        if ($email = $this->getGuestEmailByToken($token))
            $activated = $this->activateGuest($email);
        
        else if ($email = $this->getUserEmailByToken($token))
            $activated = $this->registerUser($email);
        
        
        
        if (!$activated)
            return $this->l('This email is already registered and/or invalid.');
        
        
        
        if ($discount = Configuration::get('NW_VOUCHER_CODE'))
            $this->sendVoucher($email, $discount);
        
        
        
        if (Configuration::get('NW_CONFIRMATION_EMAIL'))
            $this->sendConfirmationEmail($email);
        
        
        
        return $this->l('Thank you for subscribing to our newsletter.');
        
    }
    
    
    
    /**
    
    * Send a verification email
    
    *
    
    * @param string $email
    
    * @param string $token
    
    *
    
    * @return bool
    
    */
    
    protected function sendVerificationEmail($email, $token)
    {
        
        $verif_url = Context::getContext()->link->getModuleLink('wdpopupnewsletter', 'verification', array(
            
            'token' => $token
            
        ));
        
        
        
        return Mail::Send($this->context->language->id, 'fieldnewsletter_verif', Mail::l('Email verification', $this->context->language->id), array(
            '{verif_url}' => $verif_url
        ), $email, null, null, null, null, null, dirname(__FILE__) . '/mails/', false, $this->context->shop->id);
        
    }
    
    
    
    /**
    
    * Subscribe an email to the newsletter. It will create an entry in the newsletter table
    
    * or update the customer table depending of the register status
    
    *
    
    * @param string $email
    
    * @param int    $register_status
    
    */
    
    protected function register($email, $register_status)
    {
        
        if ($register_status == self::GUEST_NOT_REGISTERED)
            return $this->registerGuest($email);
        
        
        
        if ($register_status == self::CUSTOMER_NOT_REGISTERED)
            return $this->registerUser($email);
        
        
        
        return false;
        
    }
    
    
    
    /**
    
    * Subscribe a customer to the newsletter
    
    *
    
    * @param string $email
    
    *
    
    * @return bool
    
    */
    
    protected function registerUser($email)
    {
        
        $sql = 'UPDATE ' . _DB_PREFIX_ . 'customer

                SET `newsletter` = 1, newsletter_date_add = NOW(), `ip_registration_newsletter` = \'' . pSQL(Tools::getRemoteAddr()) . '\'

                WHERE `email` = \'' . pSQL($email) . '\'

                AND id_shop = ' . $this->context->shop->id;
        
        
        
        return Db::getInstance()->execute($sql);
        
    }
    
    
    
    /**
    
    * Send an email containing a voucher code
    
    *
    
    * @param $email
    
    * @param $code
    
    *
    
    * @return bool|int
    
    */
    
    protected function sendVoucher($email, $code)
    {
        
        return Mail::Send($this->context->language->id, 'fieldnewsletter_voucher', Mail::l('Newsletter voucher', $this->context->language->id), array(
            '{discount}' => $code
        ), $email, null, null, null, null, null, dirname(__FILE__) . '/mails/', false, $this->context->shop->id);
        
    }
    
    
    
    /**
    
    * Send a confirmation email
    
    *
    
    * @param string $email
    
    *
    
    * @return bool
    
    */
    protected function sendConfirmationEmail($email)
    {
        
        return Mail::Send($this->context->language->id, 'fieldnewsletter_conf', Mail::l('Newsletter confirmation', $this->context->language->id), array(), pSQL($email), null, null, null, null, null, dirname(__FILE__) . '/mails/', false, $this->context->shop->id);
        
    }
    
    
    /**
    
    * Register in block newsletter
    
    */
    
    public function newsletterRegistration($email)
    {
        
      if (empty($email) || !Validate::isEmail($email)) {
			echo Tools::getValue('callback').'('.Tools::jsonEncode(array('<p class="alert alert-danger">'.$this->l('Invalid email address.').'</p>')).')';
			return;
		}
        
        
        
        $register_status = $this->isNewsletterRegistered($email);
        
   	if ($register_status > 0) {
			echo Tools::getValue('callback').'('.Tools::jsonEncode(array('<p class="alert alert-danger">'.$this->l('This email address is already registered.').'</p>')).')';
			return;
		}
        
        
        
        $email = pSQL($email);
        
        if (!$this->isRegistered($register_status)) {
            
            if (Configuration::get('NW_VERIFICATION_EMAIL')) {
                
                // create an unactive entry in the newsletter database
                
                if ($register_status == self::GUEST_NOT_REGISTERED)
                    $this->registerGuest($email, false);
                
                
                
         	if (!$token = $this->getToken($email, $register_status)) {
			echo Tools::getValue('callback').'('.Tools::jsonEncode(array('<p class="alert alert-danger">'.$this->l('An error occurred during the subscription process.').'</p>')).')';
					return;
				}
                $this->sendVerificationEmail($email, $token);
                echo Tools::getValue('callback').'('.Tools::jsonEncode(array('<p class="alert alert-success">'.$this->l('A verification email has been sent. Please check your inbox.').'</p>')).')';
                
                return;
                
            }
            
            else {
                
                if ($resp = $this->register($email, $register_status)) {
                    
                    if ($code = Configuration::get('NW_VOUCHER_CODE'))
                        $resp = $this->sendVoucher($email, $code);
                    
                    
                    
                    if (Configuration::get('NW_CONFIRMATION_EMAIL'))
                        $resp = $this->sendConfirmationEmail($email);
                    
                    
                    
                    if ($resp == true)
                        	echo Tools::getValue('callback').'('.Tools::jsonEncode(array('<p class="alert alert-success">'.$this->l('You have successfully subscribed to this newsletter.').'</p>')).')';
                    
                    else
                      echo Tools::getValue('callback').'('.Tools::jsonEncode(array('<p class="alert alert-success">'.$resp.'</p>')).')';
                    
                    
                    
                    return;
                    
                }
                
                else {
                    
                   echo Tools::getValue('callback').'('.Tools::jsonEncode(array('<p class="alert alert-danger">'.$this->l('An error occurred during the subscription process.').'</p>')).')';
                    
                    return;
                    
                }
                
            }
            
        }
        
    }
    
    
    
} 