{**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2021 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
<!doctype html>
<html lang="{$language.iso_code}">

  <head>
    {block name='head'}
      {include file='_partials/head.tpl'}
    {/block}
  </head>

  <body id="{$page.page_name}" class="{$page.body_classes|classnames}">
    {block name='hook_after_body_opening_tag'}
      {hook h='displayAfterBodyOpeningTag'}
    {/block}

    <main>
        {block name='header_nav'}
          <nav class="header-nav">
          <div class="top-nav">
                <div class="left-nav">
                <div class="container">
                  {hook h='displayNav1'}
                </div>
                </div>
                <div class="nav2">
                <div class="container">
                  {hook h='displayNav2'}
                </div>
                </div>
            </div>
          </nav>
        {/block}
		 	  <div class="page-inner container">
         <div class="page-inner-bg">

	      <header id="header">
        {block name='header'}
          {include file='_partials/header.tpl'}
        {/block}
      </header>
		{block name='breadcrumb'}
            {include file='_partials/breadcrumb.tpl'}
          {/block}

      {block name='product_activation'}
        {include file='catalog/_partials/product-activation.tpl'}
      {/block}
	 <div id="page" class="">
<div class="wdloading-bg"></div>

{if $page.page_name == 'index'}
		{block name='top_column_before'}
			<div id="top_column_before">
					{hook h='displayTopColumnBefore'}
			 </div>
		{/block}
		{/if}
	  	{if $page.page_name == 'index'}
		{block name='top_column'}
			<div id="top_column">
					{hook h='displayTopColumn'}
			 </div>
		{/block}
		{/if}


      <section id="wrapper">

        {hook h="displayWrapperTop"}
		  	        {block name='notifications'}
        {include file='_partials/notifications.tpl'}
      {/block}
	  <div class="content_wrap">
          {block name="left_column"}
            <div id="left-column" class="col-xs-12 col-sm-4 col-md-3">
              {if $page.page_name == 'product'}
                {hook h='displayLeftColumnProduct'}
              {else}
                {hook h="displayLeftColumn"}
              {/if}
            </div>
          {/block}

          {block name="content_wrapper"}
            <div id="content-wrapper" class="left-column right-column col-sm-4 col-md-6">
              {hook h="displayContentWrapperTop"}
              {block name="content"}
                <p>Hello world! This is HTML5 Boilerplate.</p>
              {/block}
              {hook h="displayContentWrapperBottom"}
            </div>
          {/block}

          {block name="right_column"}
            <div id="right-column" class="col-xs-12 col-sm-4 col-md-3">
              {if $page.page_name == 'product'}
                {hook h='displayRightColumnProduct'}
              {else}
                {hook h="displayRightColumn"}
              {/if}
            </div>
          {/block}
        {hook h="displayWrapperBottom"}
		</div>

      </section>

 
      </div>

	</div>
	</div>
       <footer id="footer">
        {block name="footer"}
          {include file="_partials/footer.tpl"}
        {/block}
      </footer>
    </main>

    {block name='javascript_bottom'}
      {include file="_partials/javascript.tpl" javascript=$javascript.bottom}
    {/block}

    {block name='hook_before_body_closing_tag'}
      {hook h='displayBeforeBodyClosingTag'}
    {/block}
  </body>

</html>
