{**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 *}
<div id="quickview-modal-{$product.id}-{$product.id_product_attribute}" class="modal fade quickview" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
   <div class="modal-content">
     <div class="modal-header">
       <button type="button" class="close" data-dismiss="modal" aria-label="{l s='Close' d='Shop.Theme.Global'}">
         <span aria-hidden="true">&times;</span>
       </button>
     </div>
     <div class="modal-body">
      <div class="row">
        <div class="col-md-5 col-sm-5 hidden-xs-down">
          {block name='product_cover_thumbnails'}
            {include file='catalog/_partials/product-cover-thumbnails.tpl'}
          {/block}
        </div>
        <div class="col-md-7 col-sm-7">
          <h1 class="h1 wd-producttitle">{$product.name}</h1>
          {block name='product_prices'}
            {include file='catalog/_partials/product-prices.tpl'}
          {/block}
          {block name='product_description_short'}
            <div id="product-description-short" itemprop="description">{$product.description_short nofilter}</div>
          {/block}
          {block name='product_buy'}
            <div class="product-actions">
              <form action="{$urls.pages.cart}" method="post" id="add-to-cart-or-refresh">
                <input type="hidden" name="token" value="{$static_token}">
                <input type="hidden" name="id_product" value="{$product.id}" id="product_page_product_id">
                <input type="hidden" name="id_customization" value="{$product.id_customization}" id="product_customization_id">
                {block name='product_variants'}
                  {include file='catalog/_partials/product-variants.tpl'}
                {/block}

                {block name='product_add_to_cart'}
                  {include file='catalog/_partials/product-add-to-cart.tpl'}
                {/block}

                {* Input to refresh product HTML removed, block kept for compatibility with themes *}
                {block name='product_refresh'}{/block}
            </form>
          </div>
        {/block}
        </div>
      </div>
     </div>
     <div class="modal-footer">
        <div class="product-additional-info">
          {hook h='displayProductAdditionalInfo' product=$product}
        </div>
    </div>
   </div>
 </div>
</div>
<script type="text/javascript">
$(document).ready(function() {
 producquicktadditional(".quickview .mask .product-images");
});
    /* ----------- carousel For FeatureProduct ----------- */
	function producquicktadditional(productId){
			var wdquickview = $('.quickview .mask .product-images').owlCarousel({
						items : 3, //1 items above 1000px browser width
						nav : true,
						dots : false,
						loop: false,
						autoplay:false,	
						rtl:false,
						navText: [
						"<i class='material-icons'>&#xE5CB;</i>",
						"<i class='material-icons'>&#xE5CC;</i>"
						],
						responsive: {
							0:{
								items:2
							},
							544:{
								items:3
							},
							768:{
								items:4
							},
							992:{
								items:3
							},
							1200:{
								items:3
							}
						}
					});
				// Custom Navigation Events
			  $(".wdquickview_prev").click(function(){
					wdquickview.trigger('prev.owl.carousel',[700]);
			  })
			  $(".wdquickview_next").click(function(){
					wdquickview.trigger('next.owl.carousel',[700]);
			  })	
		}
    /* ----------- carousel For wdnew-products ----------- */
</script>
