{**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2021 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
<div id="js-product-list-top" class="products-selection">
  <div class="col-md-6 hidden-sm-down total-products">
    	<!-- Grid-List Buttons --> 
	<div class="grid_list col-md-6">
			<ul class="nav nav-tabs" role="tablist">
		<li class="nav-item tab grid1">
			<a class="nav-link grid_view2" data-toggle="tab" href="#tab-gridview2" role="tab"><span class="material-icons">grid_on</span></a>
		</li>
		<li class="nav-item tab grid2">
			<a class="nav-link grid_view active" data-toggle="tab" href="#tab-gridview" role="tab"><span class="material-icons">grid_on</span></a>
		</li>
		<li class="nav-item tab list1">
			<a class="nav-link list_view" data-toggle="tab" href="#tab-listview" role="tab"><span class="material-icons">format_list_bulleted</span></a>
		</li>
		<li class="nav-item tab list2">
			<a class="nav-link list_view2" data-toggle="tab" href="#tab-listview2" role="tab"><span class="material-icons">format_list_bulleted</span></a>
		</li>
		<li class="nav-item tab sort">
			<a class="nav-link sort_view" data-toggle="tab" href="#tab-shortview" role="tab"><span class="material-icons">dehaze</span></a>
		</li>
		</ul>
	</div>
    {if $listing.pagination.total_items > 1}
      <p>{l s='There are %product_count% products.' d='Shop.Theme.Catalog' sprintf=['%product_count%' => $listing.pagination.total_items]}</p>
    {elseif $listing.pagination.total_items > 0}
      <p>{l s='There is 1 product.' d='Shop.Theme.Catalog'}</p>
    {/if}
  </div>
  <div class="col-md-6">
    <div class="row sort-by-row">

      {block name='sort_by'}
        {include file='catalog/_partials/sort-orders.tpl' sort_orders=$listing.sort_orders}
      {/block}

      {if !empty($listing.rendered_facets)}
        <div class="col-sm-3 col-xs-4 hidden-md-up filter-button">
          <button id="search_filter_toggler" class="btn btn-secondary">
            {l s='Filter' d='Shop.Theme.Actions'}
          </button>
        </div>
      {/if}
    </div>
  </div>
  <div class="col-sm-12 hidden-md-up text-sm-center showing">
    {l s='Showing %from%-%to% of %total% item(s)' d='Shop.Theme.Catalog' sprintf=[
    '%from%' => $listing.pagination.items_shown_from ,
    '%to%' => $listing.pagination.items_shown_to,
    '%total%' => $listing.pagination.total_items
    ]}
  </div>
</div>
