

{**
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License 3.0 (AFL-3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* https://opensource.org/licenses/AFL-3.0
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
* @author    PrestaShop SA <contact@prestashop.com>
* @copyright 2007-2021 PrestaShop SA
* @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
* International Registered Trademark & Property of PrestaShop SA
*}
{block name='product_miniature_item'}
<div itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem">
   {if isset($position)}
   <meta itemprop="position" content="{$position}" />
   {/if}
   <article class="product-miniature js-product-miniature product-list" data-id-product="{$product.id_product}" data-id-product-attribute="{$product.id_product_attribute}">
      <div class="thumbnail-container">
         <div class="wdproduct-image col-sm-5">
            {block name='product_thumbnail'}
            {if $product.cover}
            <a href="{$product.canonical_url}" class="thumbnail product-thumbnail">
               <img
                  class="wdproduct-img1"
                  src = "{$product.cover.bySize.medium_default.url}"
                  alt = "{if !empty($product.cover.legend)}{$product.cover.legend}{else}{$product.name|truncate:30:'...'}{/if}"
                  data-full-size-image-url = "{$product.cover.large.url}"
                  >
            </a>
            {else}
            <a href="{$product.canonical_url}" class="thumbnail product-thumbnail">
            <img
               class="wdproduct-img1"
               src = "{$urls.no_picture_image.bySize.home_default.url}"
               >
            </a>
            {/if}
            {/block}
            <!-- @todo: use include file='catalog/_partials/product-flags.tpl'} -->
            {block name='product_flags'}
            <ul class="product-flags">
               {foreach from=$product.flags item=flag}
               <li class="{$flag.type}">{$flag.label}</li>
               {/foreach}
            </ul>
            {/block}
                      {if $product.has_discount}
               {if $product.discount_type === 'percentage'}
               <span class="discount-percentage discount-product">{$product.discount_percentage}</span>
               {elseif $product.discount_type === 'amount'}
               <span class="discount-amount discount-product">{$product.discount_amount_to_display}</span>
               {/if}
               {/if}
            <div class="label">
               {if $product.quantity == 0}
               <span>{l s='out of stock' d='Shop.Theme.Actions'}</span>
               {/if}
            </div>

         </div>
         <div class="wdproduct-desc col-sm-7">
            <div class="product-description">
               <h5 class="cat-name">{$product.category|escape:'html':'UTF-8'}</h5>
               {block name='product_reviews'}
               {hook h='displayProductListReviews' product=$product}
               {/block}
			               
               {block name='product_name'}
               {if $page.page_name == 'index'}
               <span class="h3 product-title" itemprop="name"><a href="{$product.canonical_url}">{$product.name}</a></span>
               {else}
               <span class="h3 product-title" itemprop="name"><a href="{$product.canonical_url}">{$product.name}</a></span>
               {/if}
               {/block}
               {block name='product_description_short'}
               <div class="product-desc-short" itemprop="description">{$product.description_short|strip_tags:'UTF-8'|truncate:150:'...' nofilter}</div>
               {/block}
               {block name='product_price_and_shipping'}
               {if $product.show_price}
               <div class="product-price-and-shipping">
                  <span itemprop="price" class="price {if $product.has_discount}offer-price{/if}">{$product.price}</span>
                  {if $product.has_discount}
                  {hook h='displayProductPriceBlock' product=$product type="old_price"}
        
                  <span class="sr-only">{l s='Regular price' d='Shop.Theme.Catalog'}</span>
                  <span class="regular-price">{$product.regular_price}</span>
                  {/if}
                  {hook h='displayProductPriceBlock' product=$product type="before_price"}
                  <span class="sr-only">{l s='Price' d='Shop.Theme.Catalog'}</span>
                  {hook h='displayProductPriceBlock' product=$product type='unit_price'}
                  {hook h='displayProductPriceBlock' product=$product type='weight'}
               </div>
               {/if}
               {/block}
                           <div class="highlighted-informations{if !$product.main_variants} no-variants{/if} hidden-sm-down">
               {block name='product_variants'}
               {if $product.main_variants}
               {include file='catalog/_partials/variant-links.tpl' variants=$product.main_variants}
               {/if}
               {/block}
            </div>

            <div class="wdqtyprogress">
			<span class="QuantityAvailable">{if $product.quantity <= 0}{l s='Unavilable:' d='Shop.Theme.Actions'}{else}{l s='Available:' d='Shop.Theme.Actions'}{/if}</span>
			<span class="quantity">{$product.quantity}</span>
			<div class="progress">
				<div class="progress-bar" role="progressbar"></div>
			</div>
			</div>
                           {hook h='displayProductCountdown' product=$product}
                           			

               <div class="wdproducthover">
                  <div class="wd-button-container">
                     {include file='catalog/_partials/customize/button-cart.tpl' product=$product}
                  </div>
                                 {hook h='displayWdWishListButton' product=$product}
               {hook h='displayWdCompareButton' product=$product}
                  {block name='quick_view'}
                  <div class="quick-view-block">
                     <a href="#" class="quick-view btn" data-link-action="quickview" title="{l s='Quick view' d='Shop.Theme.Actions'}">
                     <i class='material-icons quick_view_icon'>visibility</i> <span>{l s='Quick view' d='Shop.Theme.Actions'}</span>
                     <span class="loading"><i class="material-icons">cached</i></span>
                     </a>
                  </div>
                  {/block}
               </div>
            </div>
                        {block name='product_images'}
			<div class="js-qv-mask mask">
			  <ul class="product-images wdadditional">
				{foreach from=$product.images item=image}
				  <li class="thumb-container">
					<img
					  class="thumb js-thumb-all {if $image.id_image == $product.cover.id_image} selected {/if}"
					  data-image-medium-src="{$image.bySize.medium_default.url}"
					  data-image-large-src="{$image.bySize.medium_default.url}"
					  src="{$image.bySize.cart_default.url}"
					  alt="{$image.legend}"
					  title="{$image.legend}"
					  width="100"
					  height="130"
					  itemprop="image"
					>
				  </li>
				{/foreach}
			  </ul>			  
			</div>
			 <div class="scroll-box-arrows">
                <i class="material-icons left">&#xE314;</i>
                <i class="material-icons right">&#xE315;</i>              
                </div>
			{/block}
         </div>
      </div>
   </article>
</div>
{/block}


