{**
 * 2007-2019 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2019 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
{block name='product_miniature_item'}
	<div itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="product">
{if isset($position)}<meta itemprop="position" content="{$position}" />{/if}
<article class="product-miniature js-product-miniature product-list col-xs-12" data-id-product="{$product.id_product}" data-id-product-attribute="{$product.id_product_attribute}">
	<div class="thumbnail-container">
		<div class="wdproduct-image col-xs-5 col-sm-5 col-md-3">
		   {block name='product_thumbnail'}
				{if $product.cover}
				  <a href="{$product.canonical_url}" class="thumbnail product-thumbnail">
					<img
				      class="wdproduct-img1"
					  src = "{$product.cover.bySize.home_default.url}"
					  alt = "{if !empty($product.cover.legend)}{$product.cover.legend}{else}{$product.name|truncate:30:'...'}{/if}"
					  data-full-size-image-url = "{$product.cover.large.url}" width="337" height="337"
					>
					{hook h="displayWdproductImageHover" id_product=$product.id_product home='home_default' large='large_default'}
				  </a>
				{else}
				  <a href="{$product.canonical_url}" class="thumbnail product-thumbnail">
					<img
				      class="wdproduct-img1"
					  src = "{$urls.no_picture_image.bySize.home_default.url}"
					>
				  </a>
				{/if}
			  {/block}
			  
		<!-- @todo: use include file='catalog/_partials/product-flags.tpl'} -->
			{block name='product_flags'}
				<ul class="product-flags">
					{foreach from=$product.flags item=flag}
						<li class="{$flag.type}">{$flag.label}</li>
					{/foreach}
				</ul>
			{/block}
<div class="label">
				{if $product.quantity == 0}
					<span>{l s='out of stock' d='Shop.Theme.Actions'}</span>
				{/if}
				</div>	
		</div>
		
		<div class="wdproduct-desc col-xs-7 col-sm-7 col-md-9">
			<div class="product-description">
				<h5 class="cat-name">{$product.category|escape:'html':'UTF-8'}</h5>

				{block name='product_name'}
				  {if $page.page_name == 'index'}
					<span class="h3 product-title" itemprop="name"><a href="{$product.canonical_url}">{$product.name}</a></span>
				  {else}
					<span class="h3 product-title" itemprop="name"><a href="{$product.canonical_url}">{$product.name}</a></span>
				  {/if}
				{/block}
										{block name='product_reviews'}
				{hook h='displayProductListReviews' product=$product}
			{/block}
				{block name='product_description_short'}
					<div class="product-desc-short" itemprop="description">{$product.description_short|strip_tags:'UTF-8'|truncate:150:'...' nofilter}</div>
				{/block}
		
					
			
				{block name='product_price_and_shipping'}
					{if $product.show_price}
						<div class="product-price-and-shipping">
							<span itemprop="price" class="price {if $product.has_discount}offer-price{/if}">{$product.price}</span>
							{if $product.has_discount}
								{hook h='displayProductPriceBlock' product=$product type="old_price"}
								<span class="sr-only">{l s='Regular price' d='Shop.Theme.Catalog'}</span>
								{if $product.discount_type === 'percentage'}
									 <span class="discount-percentage discount-product">{$product.discount_percentage}</span>
								{elseif $product.discount_type === 'amount'}
									 <span class="discount-amount discount-product">{$product.discount_amount_to_display}</span>
								{/if}
								<span class="regular-price">{$product.regular_price}</span>
								
							{/if}
							{hook h='displayProductPriceBlock' product=$product type="before_price"}
							<span class="sr-only">{l s='Price' d='Shop.Theme.Catalog'}</span>
							{hook h='displayProductPriceBlock' product=$product type='unit_price'}
							{hook h='displayProductPriceBlock' product=$product type='weight'}
						</div>
					{/if}
				{/block}
	
				<div class="highlighted-informations{if !$product.main_variants} no-variants{/if}">
				{block name='product_variants'}
					{if $product.main_variants}
						{include file='catalog/_partials/variant-links.tpl' variants=$product.main_variants}
					{/if}
				{/block}
				</div>
			<div class="wdproducthover">
			<div class="wd-button-container">
				{include file='catalog/_partials/customize/button-cart.tpl' product=$product}
			</div>
            <div class="wd-icon">
			{hook h='displayWdWishListButton' product=$product}
			{hook h='displayWdCompareButton' product=$product}
			{block name='quick_view'}
				<div class="quick-view-block">
					<a href="#" class="quick-view btn btn-primary" data-link-action="quickview" title="{l s='Quick view'}">
						<i class='material-icons quick_view_icon'>visibility</i><span>{l s='Quick view' d='Shop.Theme.Actions'}</span><span class="loading"><i class="material-icons">cached</i></span>
					</a>
				</div>
			{/block}
            </div>
			</div>


			</div>
		</div>
	</div>
</article>
</div>
{/block}