{*
*  @author    WebDigify
*  @copyright 2015-2017 WebDigify. All Rights Reserved.
*  @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
*}

{if $products}
    {if !$refresh}
        <div class="wishlistLinkTop">
            <p class="wishlisturl form-group">
                <label>{l s='Permalink' mod='wdproductwishlist'}:</label>
                <input type="text" class="form-control" value="{$link->getModuleLink('wdproductwishlist', 'view', ['token' => $token_wish])|escape:'html':'UTF-8'}" readonly="readonly"/>
            </p>
            <div id="showSendWishlist">
                <a class="btn btn-primary send" href="#" onclick="$('#wdsendwishlist-modal').modal('show');" title="{l s='Send this wishlist' mod='wdproductwishlist'}">
                    <span>{l s='Send this wishlist' mod='wdproductwishlist'}</span>
                </a>
            </div>
        </div>
    {/if}
    <div id="products" class="wlp_bought">
        <div class="products">
            {foreach from=$products item=productItem name=i}
                {assign var='product' value=$productItem.curProduct}
                {assign var='wishlist' value=$productItem.wishlistInfo}
                <article id="wlp_{$product.id_product}_{$product.id_product_attribute}" class="product-miniature js-product-miniature col-xs-6 col-sm-6 col-md-4 col-xl-2" data-id-product="{$product.id_product}" data-id-product-attribute="{$product.id_product_attribute}" itemscope itemtype="http://schema.org/Product">
                    <div class="product-container">
                        <div class="thumbnail-container">
                            <div class="thumbnail-inner">
                                {block name='product_thumbnail'}
                                    <a href="{$product.url}" class="thumbnail product-thumbnail">
                                        <img src = "{$product.cover.bySize.home_default.url}" alt = "{$product.name|escape:'html':'UTF-8'}" />
                                    </a>
                                {/block}
                            </div>
                            <a class="lnkdel" href="javascript:;" onclick="WishlistProductManage('wlp_bought', 'delete', '{$id_wishlist}', '{$product.id_product}', '{$product.id_product_attribute}', $('#quantity_{$product.id_product}_{$product.id_product_attribute}').val(), $('#priority_{$product.id_product}_{$product.id_product_attribute}').val());" title="{l s='Delete' mod='wdproductwishlist'}">
                                <i class="fa fa-times-circle"></i>
                            </a>
                        </div>
                        <div class="product-description">
                            {block name='product_name'}
                                <h1 class="h3 product-title text-capitalize" itemprop="name">
                                    <a href="{$product.url}">
                                        {$product.name}
                                    </a>
                                </h1>
                            {/block}

							{block name='product_price_and_shipping'}
                                {if $product.show_price}
                                						<div class="product-price-and-shipping">
							<span itemprop="price" class="price">{$product.price}</span>
							{if $product.has_discount}
								{hook h='displayProductPriceBlock' product=$product type="old_price"}
								{if $product.discount_type === 'percentage'}
									 <span class="discount-percentage discount-product">{$product.discount_percentage}</span>
								{elseif $product.discount_type === 'amount'}
									 <span class="discount-amount discount-product">{$product.discount_amount_to_display}</span>
								{/if}
								<span class="regular-price">{$product.regular_price}</span>
								
							{/if}
							
						</div>
                                {/if}
                            {/block}
                            <p class="form-group">
                                <label for="quantity_{$product.id_product}_{$product.id_product_attribute}">
                                    {l s='Quantity' mod='wdproductwishlist'}
                                </label>
                                <input class="form-control" type="text" id="quantity_{$product.id_product}_{$product.id_product_attribute}" value="{$wishlist.quantity|intval}" size="3" />
                            </p>

                            <p class="form-group">
                                <label for="priority_{$product.id_product}_{$product.id_product_attribute}">
                                    {l s='Priority' mod='wdproductwishlist'}:
                                </label>
                                <select id="priority_{$product.id_product}_{$product.id_product_attribute}" class="form-control grey">
                                    <option value="0"{if $wishlist.priority eq 0} selected="selected"{/if}>
                                        {l s='High' mod='wdproductwishlist'}
                                    </option>
                                    <option value="1"{if $wishlist.priority eq 1} selected="selected"{/if}>
                                        {l s='Medium' mod='wdproductwishlist'}
                                    </option>
                                    <option value="2"{if $wishlist.priority eq 2} selected="selected"{/if}>
                                        {l s='Low' mod='wdproductwishlist'}
                                    </option>
                                </select>
                            </p>
                            <div class="dropdown-action">
                            {if $wishlists|count > 1}
                                    <div class="form-group dropdown js-dropdown">
                                        {foreach name=wl from=$wishlists item=wishlist}
                                            {if $smarty.foreach.wl.first}
                                                <a class="btn btn-secondary button button-small wishlist_change_button" tabindex="0" data-toggle="dropdown" aria-expanded="false" data-trigger="focus" title="{l s='Move to a wishlist' mod='wdproductwishlist'}" data-placement="bottom">
                                                    <span>{l s='Move' mod='wdproductwishlist'}</span>
                                                </a>
                                                <div class="dropdown-menu">
                                                    <ul>
                                                    {/if}
                                                    {if $id_wishlist != {$wishlist.id_wishlist}}
                                                        <li title="{$wishlist.name|escape:'html':'UTF-8'}" value="{$wishlist.id_wishlist}" onclick="wishlistProductChange({$product.id_product}, {$product.id_product_attribute}, '{$id_wishlist}', '{$wishlist.id_wishlist}');">

                                                            {l s='Move to %s'|sprintf:$wishlist.name mod='wdproductwishlist'}

                                                        </li>
                                                    {/if}
                                                    {if $smarty.foreach.wl.last}
                                                    </ul>
                                                </div>
                                            {/if}
                                        {/foreach}
                                    </div>
                                {/if}

                            <div class="btn_action">
                                <a class="btn btn-primary"  href="javascript:;" onclick="WishlistProductManage('wlp_bought_{$product.id_product_attribute}', 'update', '{$id_wishlist}', '{$product.id_product}', '{$product.id_product_attribute}', $('#quantity_{$product.id_product}_{$product.id_product_attribute}').val(), $('#priority_{$product.id_product}_{$product.id_product_attribute}').val());" title="{l s='Save' mod='wdproductwishlist'}">
                                    <span>{l s='Save' mod='wdproductwishlist'}</span>
                                </a>
                            </div>
                            </div>
                        </div>
                    </div>
                </article>
            {/foreach}
        </div>
    </div>
    <div id="wdsendwishlist-modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="material-icons">close</i></span>
                    </button>
                    <h2 class="modal-title">
                        {l s='Send Wishlist' mod='wdproductwishlist'}
                    </h2>
                </div>
                <div class="modal-body">
                    <form method="post" class="wl_send box unvisible" onsubmit="return (false);">
                        <fieldset>
                            <div class="form-group row">
                                <label for="email1" class="col-md-3 form-control-label required">
                                    {l s='Email' mod='wdproductwishlist'}
                                </label>
                                <div class="col-md-9">
                                    <input class="form-control" name="email1" id="email1" type="email">
                                </div>
                            </div>
                            {section name=i loop=11 start=2}
                                <div class="form-group row">
                                    <label for="email{$smarty.section.i.index}" class="col-md-3 form-control-label required">
                                        {l s='Email' mod='wdproductwishlist'}{$smarty.section.i.index}
                                    </label>
                                    <div class="col-md-9">
                                        <input class="form-control" name="email{$smarty.section.i.index}" id="email{$smarty.section.i.index}" type="email">
                                    </div>
                                </div>
                            {/section}
                        </fieldset>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{l s='Close' mod='wdproductwishlist'}</button>
                    <button id="submitWdWishlist" class="btn btn-primary" type="submit" name="submitWishlist" onclick="WishlistSend('wl_send', '{$id_wishlist}', 'email');">
                        <i class="fa fa-spinner fa-pulse"></i>
                        <span>{l s='Send' mod='wdproductwishlist'}</span>
                    </button>
                </div>
            </div>
        </div>
    </div>
{else}
    <p class="alert alert-warning">
        {l s='No products' mod='wdproductwishlist'}
    </p>
{/if}
