{**
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2021 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

<div class="{if !$wdpc->id}add-countdown-wrp{else}edit-countdown-wrp{/if}">
    {if !$wdpc->id}
    <button class="btn btn-primary add-wdpc">
        <i class="icon-plus-square"></i>
        {l s='Add new countdown' mod='wdproductcountdown'}
    </button>
    {/if}

    <div class="countdown-form">
        <div class="row">
            <div class="col-lg-{if $wdpc->id}11{else}12{/if}">
                <div class="form-group row wdpc-items-form-group">
                    <label class="control-label col-lg-2">
                        <span class="label-tooltip" data-toggle="tooltip" data-placement="bottom" data-html="true" title="{l s='Select products for using with this countdown' mod='wdproductcountdown'}">
                            {l s='Items:' mod='wdproductcountdown'} <sup>*</sup>
                        </span>
                    </label>
                    <div class="col-lg-10 col-xs-12 wdpc-prodselects-wrp">
                        <button class="btn btn-default wdpc-select-obj wdpc-select-products" data-type="products"><i class="icon-plus"></i> {l s='Select products' mod='wdproductcountdown'} <span class="badge badge-info wdpc-number-products">{count($wdpc_chosen_products)|intval}</span></button>

                        <div class="wdpc-select-wrp wdpc-select-wrp-products">
                            <div class="row">
                                <div class="col-lg-6 wdpc-col-filters">
                                    <span class="btn btn-default btn-xs wdpc-toggle-category-filter"><i class="icon-filter"></i> {l s='Filter by category' mod='wdproductcountdown'}</span>
                                    <span class="btn btn-default btn-xs wdpc-toggle-manufacturer-filter"><i class="icon-filter"></i> {l s='Filter by manufacturer' mod='wdproductcountdown'}</span>
                                    <label class="wdpc-search-combinations-label" for="wdpc-search-combinations-{$wdpc->id|intval}"><input type="checkbox" class="wdpc-search-combinations" id="wdpc-search-combinations-{$wdpc->id|intval}"> {l s='Search combinations' mod='wdproductcountdown'}</label>
                                    <div class="wdpc-manufacturer-wrp wdpc-filter-wrp">
                                        <select class="wdpc-manufacturer-select">
                                            <option value="">--</option>
                                            {foreach from=$wdpc_manufacturers item='manufacturer'}
                                                <option value="{$manufacturer.id_manufacturer|intval}">{$manufacturer.name|escape:'html':'UTF-8'}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                    <div class="wdpc-category-wrp wdpc-filter-wrp">
                                        {$product_category_tree nofilter} {*rendered html*}
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-6">
                                    <input type="text" class="form-control wdpc-product-search" placeholder="{l s='Search products' mod='wdproductcountdown'}">
                                </div>
                                <div class="col-lg-6"><h4>{l s='Selected products:' mod='wdproductcountdown'}</h4></div>
                            </div>
                            <div class="row">
                                <div class="col-lg-6">
                                    <select multiple class="wdpc_prod_select">
                                        <option disabled value="" class="wdpc-default-option">{l s='Search products or use filters to get results' mod='wdproductcountdown'}</option>
                                    </select>
                                    <a href="#" class="btn btn-default btn-block wdpc_multiple_select_add">
                                        {l s='Add' mod='wdproductcountdown'} <i class="icon-arrow-right"></i>
                                    </a>
                                </div>
                                <div class="col-lg-6">
                                    <select multiple class="wdpc_prod_selected" name="products[]">
                                        {foreach from=$wdpc_chosen_products item='chosen_product'}
                                            {assign var='ref' value=$wdpc_module->getProductReference($chosen_product.id_object, $chosen_product.id_product_attribute)}
                                            <option value="{$chosen_product.id_object|intval}{if $chosen_product.id_product_attribute}-{$chosen_product.id_product_attribute|intval}{/if}">#{$chosen_product.id_object|intval} {Product::getProductName($chosen_product.id_object, $chosen_product.id_product_attribute)|escape:'html':'UTF-8'} {if $ref}({l s='ref:' mod='wdproductcountdown'} {$ref|escape:'html':'UTF-8'}){/if}</option>
                                        {/foreach}
                                    </select>
                                    <a href="#" class="btn btn-default btn-block wdpc_multiple_select_del">
                                        {l s='Remove' mod='wdproductcountdown'} <i class="icon-arrow-left"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <hr>

                <div class="form-group row">
                    <label class="control-label col-lg-2">
                        <span class="label-tooltip" data-toggle="tooltip" data-placement="bottom" data-html="true" title="{l s='A text displayed alongside the countdown.' mod='wdproductcountdown'}">
                            {l s='Promo text:' mod='wdproductcountdown'}
                        </span>
                    </label>
                    <div class="col-lg-5">
                        {assign var='name_id' value="wdpc-add-name`$wdpc->id`"}
                        {$wdpc_module->generateInput(['type' => 'text', 'lang' => true, 'name' => 'name', 'class' => 'wdpc-add-name', 'id' => $name_id, 'values' => $wdpc->name]) nofilter}
                    </div>
                </div>

                <div class="form-group row datepicker-row">
                    <label class="control-label col-lg-2">
                        <span class="label-tooltip" data-toggle="tooltip" data-placement="bottom" data-html="true" title="{l s='Select time interval for this countdown.' mod='wdproductcountdown'}">
                            {l s='Display:' mod='wdproductcountdown'} <sup>*</sup>
                        </span>
                    </label>
                    <div class="col-lg-5">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="input-group">
                                    <span class="input-group-addon">{l s='from' mod='wdproductcountdown'}</span>
                                    <input type="text" name="from" class="wdpc-datepicker" value="{$wdpc->from_tz|escape:'html':'UTF-8'}" style="text-align: center;">
                                    <span class="input-group-addon"><i class="icon-calendar-empty"></i></span>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="input-group">
                                    <span class="input-group-addon">{l s='to' mod='wdproductcountdown'}</span>
                                    <input type="text" name="to" class="wdpc-datepicker" value="{$wdpc->to_tz|escape:'html':'UTF-8'}" style="text-align: center;">
                                    <span class="input-group-addon"><i class="icon-calendar-empty"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {if !$wdpc->id}
                <div class="form-group row ">
                    <div class="col-lg-2">

                    </div>
                    <div class="col-lg-4 col-xs-12">
                        <div class="alert alert-danger add-wdpc-error" style="display: none;"></div>
                        <div class="wdpc-form-btns-add">
                            <button class="btn btn-primary btn-wdpc-submit">{l s='Add' mod='wdproductcountdown'}</button>
                        </div>
                    </div>
                </div>
                {else}
                    <div class="alert alert-danger add-wdpc-error" style="display: none;"></div>
                {/if}
            </div>
            {if $wdpc->id}
                <div class="col-lg-1">
                    <div class="wdpc-form-btns-edit">
                        <button class="btn btn-primary pull-right btn-wdpc-submit"><i class="icon-save"></i> {l s='Save' mod='wdproductcountdown'}</button>
                        <input type="hidden" name="id_wdpc" value="{$wdpc->id|intval}">
                    </div>
                </div>
            {/if}
            <input type="hidden" name="action" value="saveCountdown">
            <input type="hidden" name="ajax" value="1">
        </div>

        <div class="close-countdown-form close-product-countdown-form">&#10006;</div>
    </div>
</div>
