/**
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2021 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA */
$(function () {
    wdpc_loadLocalTime();
    wdpc_loadDatetimepicker();

    // open last opened tab
    var tab_id = localStorage.getItem('wdpc_tab_id');
    if (tab_id) {
        var id = tab_id.replace('#psttab-', '');
        pst_openTab($('#psttn-' + id), tab_id);
    }

    // Tab switching
    $('.pst-tabs-list a').on('click', function(e) {
        e.preventDefault();

        var tab_id = $(this).attr('href');
        var hash = $(this).data('hash');

        pst_openTab($(this), tab_id);
    });

    $(document).on('click', '.add-wdpc', function (e) {
        e.preventDefault();
        $(this).siblings('.countdown-form').slideToggle(150);
    });
    $(document).on('click', '.close-countdown-form', function (e) {
        e.preventDefault();

        var $edit_row = $(this).parents('.wdpc_edit_row:first');
        // it's either edit form or new form
        if ($edit_row.length) {
            var $edit_row_content = $edit_row.find('.wdpc_edit_row_content');
            $edit_row.fadeOut(150);
            $edit_row_content.html('');
        } else {
            var $new_row = $(this).parents('.add-countdown-wrp:first').find('.countdown-form');
            $new_row.fadeOut(150);
        }
    });

    // Add/edit countdown
    $(document).on('click', '.btn-wdpc-submit', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var $parent = $(this).parents('.countdown-form:first');
        $parent.find('.add-wdpc-error').fadeOut(100).html('');
        $parent.find('.btn-wdpc-submit').addClass('loading');
        $parent.find('.wdpc_prod_selected option').prop('selected', true);
        $parent.find('.wdpc-swap-right option').prop('selected', true);
        var data = $parent.find(':input').serialize();

        $.ajax({
            url: wdpc_ajax_url,
            data: data,
            method: 'post',
            success: function (result) {
                if (result === '1') {
                    wdpc_reloadCountdownList();
                    wdpc_reloadBlocks();
                } else {
                    $parent.find('.add-wdpc-error').fadeIn(100).html(result);
                }
            },
            complete: function () {
                $parent.find('.btn-wdpc-submit').removeClass('loading');
            }
        });
    });

    // Delete countdown from the list
    var del_selector = '.wdpc-countdown-list .delete';
    $(document).on('click', del_selector, function (e) {
        e.preventDefault();

        var url = $(this).attr('href');
        $.ajax({
            url: url,
            method: 'post',
            beforeSend: function () {
                $('#wdpc-countdown-list').addClass('wdpc-list-loading');
            },
            complete: function () {
                wdpc_reloadCountdownList();
            }
        });
    });

    // Bulk delete timers
    $(document).on('submit', '.wdpc-countdown-list form:first', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var action = $(this).attr('action');
        if (action.indexOf('submitBulkdeletewdpc') !== -1) {
            var ids = [];
            $('[name="wdpcfBox[]"]:checked').each(function () {
                ids.push($(this).val());
            });
            $.ajax({
                url: wdpc_ajax_url,
                data: {ajax: true, action: 'bulkDeletePSPC', ids: ids},
                method: 'post',
                beforeSend: function () {
                    $('#wdpc-countdown-list').addClass('wdpc-list-loading');
                },
                success: function () {
                    wdpc_reloadCountdownList();
                }
            });
        }
        // todo can't submit form, pagination doesn't work

        return false;
    });
    // ps1.5
    $(document).on('click', '.wdpc15 [name=submitBulkdeletewdpcf]', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var ids = [];
        $('[name="wdpcfBox[]"]:checked').each(function () {
            ids.push($(this).val());
        });
        $.ajax({
            url: wdpc_ajax_url,
            data: {ajax: true, action: 'bulkDeletePSPC', ids: ids},
            method: 'post',
            beforeSend: function () {
                $('#wdpc-countdown-list').addClass('wdpc-list-loading');
            },
            success: function () {
                wdpc_reloadCountdownList();
            }
        });
        // todo can't submit form, pagination doesn't work

        return false;
    });

    // Toggle countdown status
    $(document).on('click', '.wdpc_active_toggle', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var id_wdpc = $(this).data('id-wdpc');

        if (id_wdpc) {
            $(this).parents('td:first').css('opacity', 0.4);
            $.ajax({
                url: wdpc_ajax_url,
                data: {ajax: true, action: 'changeCountdownStatus', id_wdpc: id_wdpc},
                method: 'post',
                success: function () {
                    wdpc_reloadCountdownList();
                }
            });
        }
    });

    // "edit" button in the list of timers
    $(document).on('click', '.wdpc-countdown-list .edit, .wdpc-countdown-list td.pointer', function (e) {
        e.preventDefault();

        if (!$(this).hasClass('wdpc-td-items-toggle')) {
            var $edit_row = $(this).parents('tr:first').next('.wdpc_edit_row');
            var $edit_row_content = $edit_row.find('.wdpc_edit_row_content');
            var id_wdpc = $edit_row.data('id-wdpc');

            if (!$edit_row.is(':visible')) {
                $edit_row_content.html('<div class="pst_loader"></div>');
                $edit_row.fadeToggle(150);

                $.ajax({
                    url: wdpc_ajax_url,
                    data: {ajax: true, action: 'getCountdownForm', id_wdpc: id_wdpc},
                    method: 'post',
                    success: function (html) {
                        $edit_row_content.html(html);
                        wdpc_loadDatetimepicker();
                        wdpc_initTypeWatch($edit_row.find('.wdpc-product-search'));
                    }
                });
            } else {
                $edit_row.fadeOut(150);
                $edit_row_content.html('');
            }
        }
    });

    // Click on an item link should simply open the link
    $(document).on('click', '.wdpc-item-link-wrp a', function (e) {
        e.stopPropagation();
    });

    // Toggle items list display
    $(document).on('click', '.wdpc-items-toggle', function (e) {
        e.stopPropagation();
        e.preventDefault();

        $(this).find('i').toggleClass('icon-caret-down icon-caret-up');
        $(this).parents('.wdpc-td-items-toggle').find('.wdpc-items-wrp').slideToggle(100);
    });

    // Toggle items list display
    $(document).on('click', '.wdpc-td-items-toggle', function (e) {
        e.stopPropagation();
        e.preventDefault();

        $(this).find('.wdpc-items-toggle i').toggleClass('icon-caret-down icon-caret-up');
        $(this).find('.wdpc-items-text-1').slideToggle(100);
        $(this).find('.wdpc-items-wrp').slideToggle(100);
    });

    $(document).on('change', '.wdpc-cg-all', function (e) {
        var $parent = $(this).parents('.wdpc-options-row:first');
        if ($(this).is(':checked')) {
            $parent.find('.wdpc-cg-wrp').slideUp(150);
        } else {
            $parent.find('.wdpc-cg-wrp').slideDown(150);
        }
    });

    $('#wdpc_show_pro').on('click', function (e) {
        $('#wdpc_pro_features_content').slideDown();
        $(this).remove();

        e.preventDefault();
    });
});

function wdpc_reloadCountdownList() {
    var $list_container = $('#wdpc-countdown-list');
    $list_container.addClass('wdpc-list-loading');

    $.ajax({
        url: wdpc_ajax_url,
        data: {ajax: 1, action: 'renderCountdownList'},
        method: 'post',
        success: function (result) {
            $list_container.html(result);
            wdpc_loadLocalTime();
            wdpc_loadDatetimepicker();
            wdpc_initTypeWatch();
       },
        complete: function () {
            $list_container.removeClass('wdpc-list-loading');
        }
    });
}

function pst_openTab($elem, tab_id) {
    $('.pst-tabs-list a').removeClass('active');
    $elem.addClass('active');
    $('.pst-tab-content').hide();
    $(tab_id).fadeIn(200);

    localStorage.setItem('wdpc_tab_id', tab_id);
}

function wdpc_loadLocalTime() {
    $('.wdpc-datetime-utc').each(function () {
        var text = $.trim($(this).text());
        if (text) {
            var date = moment.utc(text).format('YYYY-MM-DD HH:mm:ss');
            var stillUtc = moment.utc(date).toDate();
            var date_string = moment(stillUtc).local().format('YYYY-MM-DD HH:mm:ss');
            $(this).text(date_string);
            $(this).removeClass('wdpc-datetime-utc');
        }
    });
}