<?php
/**
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com> 
*  @copyright 2007-2021 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_'))
	exit;
	
class WdCookie extends Module
{    
    //private $_hooks = array('column','displayHeader');
    public function __construct()
	{
        $this->name = 'wdcookie';
        $this->tab = 'front_office_features';
        $this->version = '1.0.0';
        $this->author = 'WebDigify';
        $this->need_instance = 0;
        $this->bootstrap = true;
        parent::__construct();
        $this->displayName = $this->getTranslator()->trans('WD - Cookie', array(), 'Modules.WDcookie.Admin');
        $this->description = $this->getTranslator()->trans('This module displays a nice information about Cookies in your shop', array(), 'Modules.WDcookie.Admin');
        $this->ps_versions_compliancy = array('min' => '1.7.0.0', 'max' => _PS_VERSION_);
    }
     /**
	 * @see Module::install()
	 */
    public function install()
	{
        Configuration::updateValue('WD_COOKIE_STYLE','cookie_style1');    
	    return parent::install() && $this->registerHook('displayCookie') && $this->registerHook('displayHeader');
    }
    /**
	 * @see Module::uninstall()
	 */
	public function uninstall()
	{
	    Configuration::deleteByName('WD_COOKIE_STYLE');
        return parent::uninstall();
    }
	 public function hookDisplayHeader()
    {
        $this->context->controller->addCSS(($this->_path).'views/css/'.$this->name.'.css', 'all');
		$this->context->controller->addJS($this->_path . 'views/js/wdcookie.js');
    }
    public function getContent()
    {
        if(Tools::isSubmit('submitUpdate'))
        {
            Configuration::updateValue('WD_COOKIE_STYLE', Tools::strtolower(trim(Tools::getValue('WD_COOKIE_STYLE'))));
        }
        if(version_compare(_PS_VERSION_, '1.7.0', '>='))
            $postUrl = $this->context->link->getAdminLink('AdminModules', true).'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        else
            $postUrl = AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules');
        
        $this->smarty->assign(            
            array(
                'postUrl' => $postUrl,
                'cookies' => array(
                    array(
                        'id' => 'cookie_style1',
                        'name' => $this->l('Display On Bottom Footer')
                    ),
                    array(
                        'id' => 'cookie_style2',
                        'name' => $this->l('Display On Left Fix')
                    ),
                    array(
                        'id' => 'cookie_style3',
                        'name' => $this->l('Display On Right Fix')
                    ),
                    array(
                        'id' => 'cookie_style4',
                        'name' => $this->l('Display On Bottom Footer Fix')
                    )
                ),
                'WD_COOKIE_STYLE' => Configuration::get('WD_COOKIE_STYLE'),
                'setting_updated' => Tools::isSubmit('submitUpdate') ? true : false,
            )
        );        
        return $this->display(__FILE__, 'admin-config.tpl');
    }
    public function hookDisplayCookie($params)
    { 
		 $this->smarty->assign(array('WD_COOKIE_STYLE' => Configuration::get('WD_COOKIE_STYLE')));
		 if (!isset($_COOKIE['wd_cookie']))
			return $this->display(__file__, 'wdcookie.tpl');
    }
}